  
var DM_Hide = {  
    postid : 0,
    index  : 0,
    thanks : 0,
    postids : {},
    
    init : function(thanks_mod) {
        this.thanks = thanks_mod;
    },
    
    refresh_posts : function() {
        this.queue = $({});
        
        if (THIS_SCRIPT == 'showthread') {                    
            $('#posts li.postcontainer').each(function(item) {                
                var regex = new RegExp('post_([0-9]+)', 'g');
                var matches = regex.exec(this.id);
                
                if (matches != null) {
                    DM_Hide.postids[DM_Hide.index] = matches[1];
                    DM_Hide.index++;                                                                            
                }            
            });
            
            this.refresh_post(this.postids[this.index]);
        }
    },
    
    refresh_post : function(postid) {
        var postcount = $('#postcount' + postid).attr('name');
        
        this.postid = postid;
        
        this.send_request({
            postloc : 'showpost.php',
            params  : {
                'p' : postid,
                'postcount' : postcount
            } 
        });
        
        return true;
    },
    
    send_request: function(settings) {
        if (typeof(settings.postloc) == 'undefined') {
            settings.postloc = 'ajax.php?do=' + settings.action;
        }
        
        var newparams = '';
        for (var i in settings.params) {            
            newparams += '&' + i + '=' + settings.params[i];    
        }        
        
        settings.params = newparams;
        
        return YAHOO.util.Connect.asyncRequest('POST', settings.postloc, {
			success : this.ajax_completed,
			failure : this.handle_ajax_error,
			timeout : vB_Default_Timeout,
			scope : this
		}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + settings.params);
    },
    
    ajax_completed : function(ajax) {
        if (typeof(ajax.responseXML) != 'undefined') {
            var postbit = $('postbit', ajax.responseXML).text();
            
            if (postbit.length) {
                var oldpostbit = $('#post_' + this.postid);                
                var refreshed = string_to_node(postbit);
                
                oldpostbit.replaceWith(refreshed);
                
                PostBit_Init(refreshed, this.postid);
            }
            
            this.index--;
            
            if (this.index >= 0) {
                this.refresh_post(this.postids[this.index]);
            } 
            
            return true;
        } else {
            if (ajax.responseText.length) {
        		eval("var r = ("+ajax.responseText+")");
                
                // Handle actions
                switch (r.type) {
                    
                }
            }
        }
	}  
};  
  
function strip_excess_identifiers(node) {
    var regex = new RegExp('\{dmods:_(.+) ([0-9]*)?\}', 'g');
    
    if (node.nodeType == 3) { // text node
        node.nodeValue = node.nodeValue.replace(regex, '');
    } else if (node.nodeType == 1) { // element
        $(node).contents().each(function () {
            strip_excess_identifiers(this);
        });
    }
} 

$(document).ready(function() {
    if (THIS_SCRIPT != 'editpost') {
        strip_excess_identifiers(document.body);
    }
});

if (THIS_SCRIPT == 'showthread') {
    $(document).ready(function() {
        var quick_form = $('#quick_reply');
        
        quick_form.bind('submit', function() {
            DM_Hide.refresh_posts(); 
        });
        
        if (DM_Hide.thanks == 2) {
            $('.post_thanks_button').each(function(index) {                
               var regex = new RegExp('post_thanks_button_([0-9]+)');
               var matches = regex.exec(this.id);
               
               if (matches != null) {
                    $('#' + this.id).bind('click', function() {
                        DM_Hide.refresh_post(matches[1]); 
                    });
               }
            });
        }
    });
}